<?php

namespace App\Exports\SuperAdmin;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class TherapistCommunitysExport implements FromArray, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    protected $therapist_communitys;
    public function __construct($therapist_communitys)
    {
        $this->therapist_communitys = $therapist_communitys;
    }
    public function array(): array
    {
        $data = [];
        foreach ($this->therapist_communitys as $therapist_community) {
            $single = [$therapist_community->id, $therapist_community->name, $therapist_community->description, $therapist_community->is_active, date_format($therapist_community->created_at, 'd-m-Y')];
            $data[] = $single;
        }
        return $data;
    }
    public function headings(): array
    {
        return ["id", "name", "description", "is_active", "created_at"];
    }
}
